/*******************************************************************************
 * Copyright (c) 2000, 2016 IBM Corporation and others.
 *
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Dmitry Stalnov (dstalnov@fusionone.com) - contributed fix for
 *       bug "inline method - doesn't handle implicit cast" (see
 *       https://bugs.eclipse.org/bugs/show_bug.cgi?id=24941).
 *******************************************************************************/
package org.eclipse.jdt.internal.corext.dom;

import org.eclipse.jdt.core.dom.ITypeBinding;

/**
 * Interface used in type binding visiting algorithms.
 *
 * @see Bindings#visitHierarchy(ITypeBinding, TypeBindingVisitor)
 */
public interface TypeBindingVisitor {

	/**
	 * @param type a type binding
	 * @return <code>true</code> to continue visiting types,
	 *         or <code>false</code> to abort and return <code>false</code>
	 */
	public boolean visit(ITypeBinding type);
}
